# Poisson_plot.R
# Plot probabilities for the binomial distribution

# Load necessary libraries
library(ggplot2)

# Poisson parameter here
lambda <- 2

# Poisson distribution function
ymax <- 20
y <- 0:ymax
proby <- dpois(y,lambda)

# Make data frame for ggplot2
poisdata <- as.data.frame(cbind(y,proby))

# Print data
poisdata

# Generate plot showing frequencies
ggplot(poisdata,aes(y,proby))+
geom_bar(stat="identity",width=0.05,fill="red")+
geom_point(color="red",size=3)+
ggtitle("Poisson distribution, lambda = 5")
